/* TC58NVG3S0FTA00.h */
#ifndef TC58NVG3S0FTA00_H
#define TC58NVG3S0FTA00_H

#define MTD_NAND_MN2WS_PAGE_SIZE_MASK	0x03
/* TOSHIBA does not have oob size */
#define MTD_NAND_MN2WS_BLOCK_SIZE_MASK	0x30
/* TOSHIBA does not have width size */

#define MTD_NAND_MN2WS_PAGE_SIZE_SHIFT	0x00
/* TOSHIBA does not have oob size */
#define MTD_NAND_MN2WS_BLOCK_SIZE_SHIFT	0x04
/* TOSHIBA does not have width size */

#define MTD_NAND_MN2WS_PAGE_SIZE_BASE	1024
/* TOSHIBA does not have oob size */
#define MTD_NAND_MN2WS_BLOCK_SIZE_BASE	(64 * 1024)
/* TOSHIBA does not have width size */

#define MTD_NAND_MN2WS_ID_READ_NUM	5

static inline uint32_t nand_gpbc_get_writesize(u8 id_data)
{
	int bits = (id_data & MTD_NAND_MN2WS_PAGE_SIZE_MASK) >>
		MTD_NAND_MN2WS_PAGE_SIZE_SHIFT;
	return MTD_NAND_MN2WS_PAGE_SIZE_BASE << bits;
}

static inline uint32_t nand_gpbc_get_oobsize(u8 id_data)
{
	/* oob size is 232 byte. But use the following setting. */
	/* The rest area(129Byte - 232Byte) is not used */
	/* Setting value:  2KByte Page: 64, 4KByte Page: 128 */
	return 128;
}

static inline uint32_t nand_gpbc_get_erasesize(u8 id_data)
{
	int bits = (id_data & MTD_NAND_MN2WS_BLOCK_SIZE_MASK) >>
		MTD_NAND_MN2WS_BLOCK_SIZE_SHIFT;
	return MTD_NAND_MN2WS_BLOCK_SIZE_BASE << bits;
}

static inline uint32_t nand_gpbc_get_width(u8 id_data)
{
	return 8;
}

#endif /* TC58NVG3S0FTA00_H */
